/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio.customization.item.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fmaudio.customization.item.AudioCustomizationItem;
import de.keksuccino.fmaudio.customization.item.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class SelectAudioScreen
extends Screen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected AudioLayoutEditorElement element;
    protected ScrollArea audiosScrollList;
    protected Screen parent;
    protected AdvancedButton backButton;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;

    public SelectAudioScreen(Screen parent, AudioLayoutEditorElement element, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super((Component)new TextComponent(""));
        this.parent = parent;
        this.callback = callback;
        this.element = element;
        this.audiosScrollList = new ScrollArea(0, 50, 300, 0);
        this.audiosScrollList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        this.backButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.fmaudio.back", (String[])new String[0]), true, press -> {
            this.onCancel();
            Minecraft.m_91087_().m_91152_(this.parent);
        });
        UIBase.colorizeButton((AdvancedButton)this.backButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.element.object;
    }

    protected void m_7856_() {
        this.updateEntries();
        this.audiosScrollList.x = this.f_96543_ / 2 - 150;
        this.audiosScrollList.height = this.f_96544_ - 100;
    }

    protected void updateEntries() {
        if (this.audiosScrollList != null) {
            ArrayList l = new ArrayList();
            l.addAll(this.audiosScrollList.getEntries());
            for (ScrollAreaEntry e : l) {
                this.audiosScrollList.removeEntry(e);
            }
            for (AudioCustomizationItem.MenuAudio c : this.getItem().audios) {
                this.audiosScrollList.addEntry((ScrollAreaEntry)new AudioScrollAreaEntry(this.audiosScrollList, c, this));
            }
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public void m_7379_() {
        this.onCancel();
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.f_96543_ / 2;
        RenderSystem.m_69478_();
        SelectAudioScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        this.audiosScrollList.render(matrix);
        SelectAudioScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        SelectAudioScreen.m_93208_((PoseStack)matrix, (Font)this.f_96547_, (String)Locals.localize((String)"fancymenu.fmaudio.audio.choose", (String[])new String[0]), (int)(this.f_96543_ / 2), (int)20, (int)-1);
        SelectAudioScreen.m_93172_((PoseStack)matrix, (int)0, (int)(this.f_96544_ - 50), (int)this.f_96543_, (int)this.f_96544_, (int)HEADER_FOOTER_COLOR.getRGB());
        this.backButton.setX(xCenter - this.backButton.m_5711_() / 2);
        this.backButton.setY(this.f_96544_ - 35);
        this.backButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.audiosScrollList.getEntries()) {
            if (!(e instanceof AudioScrollAreaEntry) || !e.isHoveredOrFocused()) continue;
            String sourceTypeString = Locals.localize((String)"fancymenu.fmaudio.audio.sourcetype.external_local", (String[])new String[0]);
            if (((AudioScrollAreaEntry)e).audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                sourceTypeString = Locals.localize((String)"fancymenu.fmaudio.audio.sourcetype.external_web", (String[])new String[0]);
            }
            String indexString = "" + ((AudioScrollAreaEntry)e).audio.index;
            String volumeString = "" + ((AudioScrollAreaEntry)e).audio.volume;
            String[] desc = StringUtils.splitLines((String)Locals.localize((String)"fancymenu.fmaudio.audio.choose.info", (String[])new String[]{sourceTypeString, indexString, volumeString}), (String)"%n%");
            SelectAudioScreen.renderDescription(matrix, Arrays.asList(desc), mouseX, mouseY);
        }
    }

    protected static void renderDescription(PoseStack matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((PoseStack)matrix, (int)600);
            SelectAudioScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.m_69478_();
            int i2 = 5;
            for (String s : desc) {
                SelectAudioScreen.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((PoseStack)matrix);
            RenderSystem.m_69461_();
        }
    }

    protected static void renderDescriptionBackground(PoseStack matrix, int x, int y, int width, int height) {
        Gui.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    public static class AudioScrollAreaEntry
    extends ScrollAreaEntry {
        protected AudioCustomizationItem.MenuAudio audio;
        protected Font font;
        protected SelectAudioScreen parentScreen;
        protected boolean isMouseDown;

        public AudioScrollAreaEntry(ScrollArea parent, AudioCustomizationItem.MenuAudio audio, SelectAudioScreen parentScreen) {
            super(parent);
            this.font = Minecraft.m_91087_().f_91062_;
            this.isMouseDown = false;
            this.audio = audio;
            this.parentScreen = parentScreen;
        }

        public void renderEntry(PoseStack matrix) {
            int center = this.x + this.getWidth() / 2;
            if (!this.isHoveredOrFocused()) {
                AudioScrollAreaEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            } else {
                AudioScrollAreaEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.brighter().brighter().getRGB());
            }
            Object sourceString = this.audio.path;
            if (this.font.m_92895_((String)sourceString) > this.getWidth() - 30) {
                sourceString = new StringBuilder((String)sourceString).reverse().toString();
                sourceString = this.font.m_92834_((String)sourceString, this.getWidth() - 30);
                sourceString = new StringBuilder((String)sourceString).reverse().toString();
                sourceString = ".." + (String)sourceString;
            }
            AudioScrollAreaEntry.m_93208_((PoseStack)matrix, (Font)this.font, (String)sourceString, (int)center, (int)(this.y + 10), (int)-1);
            this.handleSelection();
        }

        protected void handleSelection() {
            if (!PopupHandler.isPopupActive() && !this.parentScreen.backButton.m_198029_()) {
                if (MouseInput.isLeftMouseDown() && !this.isMouseDown) {
                    if (this.isHoveredOrFocused() && this.parentScreen.callback != null) {
                        this.parentScreen.callback.accept(this.audio);
                    }
                    this.isMouseDown = true;
                }
                if (!MouseInput.isLeftMouseDown()) {
                    this.isMouseDown = false;
                }
            } else if (MouseInput.isLeftMouseDown()) {
                this.isMouseDown = true;
            }
        }

        public int getHeight() {
            return 26;
        }
    }
}

